import sys

INF = 10**30

class SegmentnoStablo:
    def __init__(self, n):
        velicina = 1
        while velicina < n:
            velicina <<= 1
        self.n = n
        self.velicina = velicina
        self.stablo = [INF] * (2 * velicina)

    def postavi(self, i, v):
        s = self.stablo
        i += self.velicina
        s[i] = v
        i >>= 1
        while i:
            levo = s[i << 1]
            desno = s[i << 1 | 1]
            s[i] = levo if levo < desno else desno
            i >>= 1

    def upit(self, l, d):
        if l > d:
            return INF
        s = self.stablo
        l += self.velicina
        d += self.velicina
        rez = INF
        while l <= d:
            if l & 1:
                v = s[l]
                if v < rez:
                    rez = v
                l += 1
            if not (d & 1):
                v = s[d]
                if v < rez:
                    rez = v
                d -= 1
            l >>= 1
            d >>= 1
        return rez


def main():
    podaci = sys.stdin.read().split()
    it = iter(podaci)

    n = int(next(it))
    x = [int(next(it)) for _ in range(n)]
    h = [int(next(it)) for _ in range(n)]

    
    indeksi = list(range(n))
    indeksi.sort(key=lambda i: x[i])

    xs = [x[i] for i in indeksi]
    hs = [h[i] for i in indeksi]

    poz = [0] * n
    for i, orig in enumerate(indeksi):
        poz[orig] = i

   
    segLevo = SegmentnoStablo(n)
    segDesno = SegmentnoStablo(n)

   
    jarboli = list(range(n))
    jarboli.sort(key=lambda i: -hs[i])

    
    upiti = list(range(n))
    upiti.sort(key=lambda i: -h[i])

    rezultat = [-1] * n
    pokaz = 0

    for ui in upiti:
        visina_i = h[ui]
        poz_x = x[ui]
        p = poz[ui]

        
        while pokaz < n and hs[jarboli[pokaz]] >= visina_i:
            j = jarboli[pokaz]
            segLevo.postavi(j, -hs[j] - xs[j])
            segDesno.postavi(j, -hs[j] + xs[j])
            pokaz += 1

        
        levo = segLevo.upit(0, p - 1)
        
        desno = segDesno.upit(p + 1, n - 1)

        najbolje = INF

        if levo != INF:
            v = visina_i + (levo + poz_x)
            if v < najbolje:
                najbolje = v

        if desno != INF:
            v = visina_i + (desno - poz_x)
            if v < najbolje:
                najbolje = v

        if najbolje != INF:
            if najbolje < 0:
                najbolje = 0
            rezultat[ui] = najbolje
        else:
            rezultat[ui] = -1

    print("\n".join(map(str, rezultat)))


if __name__ == "__main__":
    main()